﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;

namespace Komunikaty
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            this.Text = "Uchwyt okna: " + this.Handle.ToString();
        }

        [DllImport("user32.dll")]
        private static extern int FindWindow(string nazwaKlasy, string nazwaOkna);

        private void button1_Click(object sender, EventArgs e)
        {
            int uchwyt = FindWindow(null, textBox1.Text);
            if (uchwyt == 0)
                MessageBox.Show("Nie ma okna o tytule \"" + textBox1.Text + "\"");
            else
                MessageBox.Show("Uchwyt pierwszego znalezionego okna o tytule \"" + textBox1.Text + "\" to " + uchwyt.ToString());
        }

        [DllImport("user32.dll")]
        private static extern IntPtr SendMessage(int hwnd, uint Msg, int wParam, int lParam);

        private const int WM_CLOSE = 0x0010;

        private void button2_Click(object sender, EventArgs e)
        {
            int uchwyt = FindWindow(null, textBox1.Text);
            if (uchwyt != 0) SendMessage(uchwyt, WM_CLOSE, 0, 0);
            else MessageBox.Show("Nie ma okna o tytule \"" + textBox1.Text + "\"");
        }

        private const int WM_SYSCOMMAND = 0x0112;
        private const int SC_SCREENSAVE = 0xF140;

        private void button3_Click(object sender, EventArgs e)
        {
            SendMessage((int)this.Handle, WM_SYSCOMMAND, SC_SCREENSAVE, 0);
        }
    }
}
